// utils/imageProcessor.ts
import sharp from 'sharp';
import path from 'path';
import fs from 'fs';

export const processImage = async (filePath: string, salesZoneId: string) => {
    const parsedPath = path.parse(filePath);
    const thumbnailsDir = path.join(parsedPath.dir, 'thumbnails');
    
    await fs.promises.mkdir(thumbnailsDir, { recursive: true });
  
    const thumbnailPath = path.join(thumbnailsDir, `thumb-${parsedPath.base}`);
    
    const image = sharp(filePath);
    const metadata = await image.metadata();
    
    await image
      .resize(300, 300, { fit: 'inside' })
      .toFile(thumbnailPath);
  
    return {
      originalUrl: `/uploads/${salesZoneId}/${parsedPath.base}`,
      thumbnailUrl: `/uploads/${salesZoneId}/thumbnails/thumb-${parsedPath.base}`,
      metadata: {
        size: (await fs.promises.stat(filePath)).size,
        format: metadata.format,
        width: metadata.width,
        height: metadata.height,
        space: metadata.space,
        channels: metadata.channels
      }
    };
  };
  