// types/mongoose-paginate.d.ts
import { Document, Model } from 'mongoose';

declare module 'mongoose' {
  interface PaginateResult<T> {
    docs: T[];
    totalDocs: number;
    limit: number;
    page?: number;
    totalPages: number;
    nextPage?: number | null;
    prevPage?: number | null;
    pagingCounter: number;
    hasPrevPage: boolean;
    hasNextPage: boolean;
    meta?: any;
  }

  interface PaginateOptions {
    select?: object | string;
    sort?: object | string;
    populate?: object[] | string[] | object | string;
    lean?: boolean;
    leanWithId?: boolean;
    offset?: number;
    page?: number;
    limit?: number;
  }

  interface PaginateModel<T extends Document> extends Model<T> {
    paginate(
      query?: object,
      options?: PaginateOptions,
      callback?: (err: any, result: PaginateResult<T>) => void,
    ): Promise<PaginateResult<T>>;
  }

  interface PaginatePlugin {
    plugin: (
      schema: Schema,
      options: object
    ) => void;
  }

  const paginate: PaginatePlugin;
}