import { Router } from "express";
import { createZone, getAllZones, getZoneById } from "../controllers/zoneController";

const router = Router();

// Create a new transport zone
router.post("/zones", /* isAuthenticated, */ createZone);

// Get all zones
router.get("/zones", getAllZones);

// Add to zoneRoutes.ts
router.get(
    "/zones/:id",
    getZoneById
  );

export default router;
