import express from 'express';
import {
  getStatusById,
  createStatus,
  getAllStatuses,
  updateStatus,
  deleteStatus,
} from '../controllers/statusController';
// import { isAuthenticated, isOwner, isSuperAdmin } from 'src/middlewares';

const router = express.Router();

router.post('/status', createStatus); // Add this route
router.get('/status/:id', getStatusById);
router.get('/status', getAllStatuses);
router.put('/status/:id', updateStatus);
router.delete('/status/:id', deleteStatus);

export default router;
