import { Router } from 'express';
import { createZone, deleteZone, getAllZones, getZoneById, updateZone, updateZoneImages } from '../controllers/salesZoneController';
// import { isAuthenticated, isSuperAdmin } from 'src/middlewares';

const router = Router();

router.post('/zone-vente', createZone);
router.get('/zone-vente/:id', getZoneById);
router.get('/zone-vente', getAllZones);

// Update a product by ID
router.put('/zone-vente/:id', updateZone);
router.patch('/zone-vente/:id/images', updateZoneImages);


// Delete a product by ID
router.delete('/zone-vente/:id', deleteZone);


export default router;
