import express from "express";
import {
  getNotifications,
  markNotificationsAsRead,
  createNotification,
} from "../controllers/notificationController";
// import { isAuthenticated } from "../middlewares"; // Middleware to check authentication

const router = express.Router();

// Route to fetch notifications for the logged-in user
router.get("/notification", getNotifications);

// Route to mark all notifications as read
router.post("/notification/mark-read", markNotificationsAsRead);

// Route to create a new notification (can be restricted to admins or system actions)
router.post("/notification", createNotification);

export default router;
