import express from 'express';
import authentication from './authentication';
import users from './userRoutes';
import product from './productRoutes';
import notification from './notificationRoutes';
import salesZone from './salesZoneRoutes';
import zones from './zoneRoutes';
import files from './fileRoutes';
import status from './statusRoutes';
import log from './logRoutes';
import images from './imageRoutes';
import statistics from './staticRoutes';

const router = express.Router();

export default (): express.Router => {
    // Updated to include the required path and options (if any)
    authentication(router, '/auth', null);
    users(router, '/users', null);
    product(router, '/products', null);
    notification(router, '/notification', null);
    salesZone(router, '/zone-vente', null);
    zones(router, '/zones', null);
    files(router, '/file', null);
    status(router, '/status', null);
    log(router, '/log', null);
    images(router, '/images', null);
    statistics(router, '/statistics', null);

    return router;
};
