// Updated routes/images.ts
import express from 'express';
import {
  uploadImages,
  getImageById,
  getAllImages,
  updateImage,
  deleteImage
} from '../controllers/imageController';
import { upload } from '../config/multer';
import multer from 'multer';
import { Request, Response, NextFunction } from 'express';
const router = express.Router();



router.post('/images/upload', 
  upload.array('images', 10), // Allow up to 10 files
  uploadImages
);

// Other routes
router.get('/images/', getAllImages);
router.get('/images/:id', getImageById);
router.put('/images/:id', updateImage);
router.delete('/images/:id', deleteImage);

export default router;