import express from "express";
import {
  createFile,
  getFiles,
  updateFile,
  deleteFile,
  getFileById,
  getFileStatistics,
} from "../controllers/fileController";
// import { upload } from '../config/multer'; // Your multer configuration

// import { isAuthenticated, isOwner, isSuperAdmin } from "../middlewares";

const router = express.Router();

// ✅ Create a new file (Requires authentication)
router.post("/file", createFile);

// ✅ Get all files (Requires authentication)
router.get("/file", getFiles);

// ✅ Update a file (Only file owner or admin)
router.put('/file/:id', updateFile);

router.get('/file/stats', getFileStatistics);


// ✅ Delete a file (Only file owner or admin)
router.delete("/file/:id", deleteFile);

router.get("/file/:id", getFileById);


export default router;
