import express from 'express';
import {
  createEvent,
  getEventById,
  getAllEvents,
  updateEvent,
  deleteEvent,
} from '../controllers/eventController';
// import { isAuthenticated, isSuperAdmin, isOwner } from 'src/middlewares';

const router = express.Router();

// ✅ Only SuperAdmin can create events
router.post('/events',  createEvent);

// ✅ Anyone authenticated can view a specific event
router.get('/events/:id', getEventById);

// ✅ Public access to all events (if needed)
router.get('/events',  getAllEvents);

// ✅ Only event owner or SuperAdmin can update an event
router.put('/events/:id',  updateEvent);

// ✅ Only event owner or SuperAdmin can delete an event
router.delete('/events/:id',  deleteEvent);

export default router;
