import mongoose, { Schema, Document, Types } from 'mongoose';
import { SalesZone } from './SalesZone';

// Define the IUser interface
export interface IUser extends Document {
  _id: Types.ObjectId;
  username: string;
  email: string;
  authentication: {
    password: string;
    salt?: string;
    sessionToken?: string;
  };
  role: 'SuperAdmin' | 'Photographer' | 'Infographiste' | 'Imprimante';
  score: string;
  phone: string;
  SalesZone?: typeof SalesZone;
  fetchedAt: Date;
  isActive: boolean; // New field to track user activation status
}

// Define the UserSchema
const UserSchema: Schema = new Schema({
  username: { type: String, required: true },
  email: {
    type: String,
    required: true,
    unique: true,
    validate: { validator: (v: string) => /\S+@\S+\.\S+/.test(v), message: 'Invalid email format' },
  },
  authentication: {
    password: { type: String, required: true },
    salt: { type: String },
    sessionToken: { type: String },
  },
  role: {
    type: String,
    enum: ['SuperAdmin', 'Photographer', 'Infographiste', 'Imprimante'],
    required: true,
  },
  score: { type: String, required: true },
  phone: { type: String },
  SalesZone: { type: mongoose.Schema.Types.ObjectId, ref: 'SalesZone' },
  fetchedAt: { type: Date, default: Date.now },
  isActive: { type: Boolean, default: false }, // Default to true for active users
});

// Export the model
export const User = mongoose.model<IUser>('User', UserSchema);
