// src/models/Status.ts
import { Schema, model, Document } from 'mongoose';

interface IStatus extends Document {
  status: string;
  type: string;
  paymentMethod?: string;
  updatedBy: Schema.Types.ObjectId;
  file?: Schema.Types.ObjectId; // Optional
}

const StatusSchema = new Schema<IStatus>({
  status: { type: String, required: true },
  type: { type: String, required: true },
  paymentMethod: { type: String },
  updatedBy: { type: Schema.Types.ObjectId, ref: 'User', required: true },
  file: { type: Schema.Types.ObjectId, ref: 'File' }, // Optional
}, { timestamps: true });

export const Status = model<IStatus>('Status', StatusSchema);