import { Request, Response } from "express";
import mongoose, { Schema, Document } from 'mongoose';

// ========== Models ========== //
interface GlobalStats {
  totalUsers: number;
  activeUsers: number;
  storageUsed: number;
  monthlyVisitors: number;
}

interface UserStats {
  averageSession: number;
  retentionRate: number;
  popularFeatures: string[];
}

interface IStatistics extends Document {
  globalStats: GlobalStats;
  userStats: UserStats;
  revenue: number;
  createdAt: Date;
  updatedBy: mongoose.Types.ObjectId;
}

const StatisticsSchema: Schema = new Schema({
  globalStats: {
    totalUsers: { type: Number, default: 0 },
    activeUsers: { type: Number, default: 0 },
    storageUsed: { type: Number, default: 0 }, // in MB
    monthlyVisitors: { type: Number, default: 0 }
  },
  userStats: {
    averageSession: { type: Number, default: 0 }, // in minutes
    retentionRate: { type: Number, default: 0 }, // percentage
    popularFeatures: [{ type: String }]
  },
  revenue: { type: Number, default: 0 }, // in USD
  createdAt: { type: Date, default: Date.now },
  updatedBy: { type: Schema.Types.ObjectId, ref: 'User', required: true }
});

export const Statistics = mongoose.model<IStatistics>('Statistics', StatisticsSchema);