import mongoose, { Schema, Document, Types } from "mongoose";

export interface ISalesZone extends Document {
  name: string;
  city: string;
  country: string;
  address: string;
  basePrice: number;
  photographers: Types.ObjectId[];  // Ensure this is ObjectId[]
  images: Types.ObjectId[];         // Ensure this is ObjectId[]
}

const SalesZoneSchema = new Schema<ISalesZone>({
  name: { type: String, required: true },
  city: { type: String, required: true },
  country: { type: String, required: true },
  address: { type: String, required: true },
  basePrice: { type: Number, default: 0 },
  photographers: [{ type: Schema.Types.ObjectId, ref: "User" }], // Ensure correct type
  images: [{ type: mongoose.Schema.Types.ObjectId, ref: 'Image' }],
});

export const SalesZone = mongoose.model<ISalesZone>("SalesZone", SalesZoneSchema);
