import mongoose, { Schema, Document, Types } from 'mongoose';

// Enum for product type
enum ProductType {
  Book = 'Book',
  Iris = 'Iris',
}

// Interface for Product document
export interface IProduct extends Document {
  _id: Types.ObjectId;
  image: string;
  title: string;
  size: { format: string; weight: number; photos: number }; // Updated to an object
  type: ProductType;                  
  details: Record<string, unknown>;   
  price: number;                      
  createdAt: Date;                    
}

// Schema definition
const ProductSchema: Schema = new Schema({
  image: {
    type: String,
    required: true
  },
  title: {
    type: String,
    required: true
  },
  size: {
    format: { type: String },  // e.g., "A5"
    weight: { type: Number },  // e.g., 160
    photos: { type: Number },  // e.g., 30
  },
  type: { 
    type: String, 
    enum: Object.values(ProductType), 
    required: true 
  },
  details: { 
    type: Object, 
    required: true 
  },
  price: { 
    type: Number, 
    required: true 
  },
  createdAt: { 
    type: Date, 
    default: Date.now 
  },
});

// Model creation
export const Product = mongoose.model<IProduct>('Product', ProductSchema);
