import mongoose, { Schema, Document, Types } from 'mongoose';

// Define the IPrice interface
interface IPrice extends Document {
  amount: number;
  currency: 'EUR' | 'USD' | 'MAD';
  photographerShare: number;
  platformShare: number;
  createdBy: Types.ObjectId;
  createdAt: Date;
}

const PriceSchema: Schema = new Schema({
  amount: { type: Number, required: true },
  currency: { type: String, enum: ['EUR', 'USD', 'MAD'], required: true },
  photographerShare: { type: Number, required: true },
  platformShare: { type: Number, required: true },
  createdBy: { type: Schema.Types.ObjectId, ref: 'User', required: true },
  createdAt: { type: Date, default: Date.now }
});

// ✅ Fix: Explicitly define `this` type
PriceSchema.pre<IPrice & Document>('save', function (next) {
  if (this.photographerShare + this.platformShare !== 100) {
    return next(new Error('Total revenue share must be 100%'));
  }
  next();
});

export const Price = mongoose.model<IPrice>('Price', PriceSchema);
