
import mongoose, { Schema, Document, Types } from "mongoose";
import { User } from "./User";

interface INotification extends Document {
  userId: typeof User; // Reference to the User receiving the notification
  title: string; // Short title for the notification
  message: string; // Detailed message
  type: "info" | "success" | "error" | "warning"; // Notification type
  read: boolean; // Whether the notification has been read
  createdAt: Date; // Timestamp for notification creation
}

const NotificationSchema: Schema = new Schema({
  userId: { type: Schema.Types.ObjectId, ref: "User", required: true }, // Relates to User
  title: { type: String, required: true },
  message: { type: String, required: true },
  type: {
    type: String,
    enum: ["info", "success", "error", "warning"],
    default: "info",
  },
  read: { type: Boolean, default: false }, // Default to unread
  createdAt: { type: Date, default: Date.now },
});

export const Notification = mongoose.model<INotification>(
  "Notification",
  NotificationSchema
);
