import mongoose, { Schema, Document } from 'mongoose';
import { User } from './User'; // Assuming you have a User model

// Define the ILog interface
interface ILog extends Document {
  action: string;
  performedBy: typeof User; // Reference to the User who performed the action
  timestamp: Date;
  details: {
    zoneId?: string;
    updatedFields?: Object;
    // Add other fields as needed
  };
}

const LogSchema: Schema = new Schema({
  action: { type: String, required: true },
  performedBy: { type: mongoose.Schema.Types.ObjectId, ref: 'User', required: true },
  timestamp: { type: Date, default: Date.now },
  details: { type: Schema.Types.Mixed }, // Flexible structure for details
});

export const Log = mongoose.model<ILog>('Log', LogSchema);