import mongoose, { Schema, Document, Types } from 'mongoose';
import { User } from './User';

// Define the IImage interface
interface IImage extends Document {
  originalUrl: string;  // High-resolution image URL
  thumbnailUrl: string; // Thumbnail URL
  uploadedBy: Types.ObjectId; // Reference to User (Photographer/SuperAdmin)
  createdAt: Date; // Timestamp
  metadata?: {
    size: number; // File size in KB/MB
    format: string; // jpg, png, etc.
    resolution: string; // Example: "1920x1080"
  };
  tags: string[]; // Image tags
}

const ImageSchema: Schema = new Schema({
  originalUrl: { type: String, required: true },
  thumbnailUrl: { type: String, required: true },
  uploadedBy: { type: mongoose.Schema.Types.ObjectId, ref: 'User', required: true },
  zone: { type: mongoose.Schema.Types.ObjectId, ref: 'SalesZone' },
  file: { type: mongoose.Schema.Types.ObjectId, ref: 'File' },
  metadata: {
    size: Number,
    format: String,
    resolution: String
  },
  tags: [String],
  uploadedAt: { type: Date, default: Date.now }
});

export const Image = mongoose.model<IImage>('Image', ImageSchema);
