import mongoose, { Schema, Document } from 'mongoose';
import { User } from './User'; // Import the User model
import { Product } from './Product';
import { Status } from './Status';
import { SalesZone } from './SalesZone';
import { Zone } from './Zone';
import { Image } from './Image';
import { Types } from 'mongoose';

// Define the IFile interface
interface IFile extends Document {
  clientName: string;
  email: string;
  phone: string;
  address: { // Add address information
    street: string;
    city: string;
    state: string;
    postalCode: string;
  };
  projectType: 'LivrePhoto' | 'IrisPhoto';
  product: typeof Product;
  salesZone: typeof SalesZone;
  delivery: typeof Zone;
  status: typeof Status;
  images: Types.ObjectId[]; // Changed from 'image' to 'images'
  total: string;
  assignedTo: typeof User; // Reference to the User who is assigned to the file
  createdAt: Date;
}

const FileSchema: Schema = new Schema({
  clientName: { type: String, required: true },
  email: { type: String },
  phone: { type: String },
  address: { // Add address information
    street: { type: String },
    city: { type: String },
    state: { type: String },
    postalCode: { type: String },
  },
  projectType: {
    type: String,
    enum: ['LivrePhoto', 'IrisPhoto'],
    required: true,
  },
  product: { type: mongoose.Schema.Types.ObjectId, ref: 'Product', required: true },
  salesZone: { type: mongoose.Schema.Types.ObjectId, ref: 'SalesZone', required: true },
  delivery: { type: mongoose.Schema.Types.ObjectId, ref: 'Zone' },
  status: { type: mongoose.Schema.Types.ObjectId, ref: 'Status', required: true },
  images: [{ 
    type: Schema.Types.ObjectId, 
    ref: 'Image',
    default: []
  }],
  total: { type: String },
  assignedTo: { type: mongoose.Schema.Types.ObjectId, ref: 'User', required: true },
  createdAt: { type: Date, default: Date.now, required: true },
});

export const File = mongoose.model<IFile>('File', FileSchema);
