import mongoose, { Schema, Document, Types } from 'mongoose';

interface IEvent extends Document {
  name: string;
  date: Date;
  location: string; // Event is in a Zone
  photographers: mongoose.Types.ObjectId[] | []; // Array of photographer user IDs
  basePrice: number; // Specific event price per zone
  image: typeof Image | null;
}

const EventSchema: Schema = new Schema({
  name: { type: String, required: true },
  date: { type: Date, required: true },
  location: { type: String, required: true }, // Zone ID
  photographers: [{ type: mongoose.Schema.Types.ObjectId, ref: 'User', unique: true, required: false, default: null } ], // Stores photographer user IDs
  basePrice: { type: Number }, // Custom price per zone
  image: { type: mongoose.Schema.Types.ObjectId, ref: 'Image', required: false, default: null }
});

export const Event = mongoose.model<IEvent>('Event', EventSchema);
