// src/helper/email.ts
import nodemailer from 'nodemailer';

const transporter = nodemailer.createTransport({
  host: 'mail.comeinup.com', // Your SMTP server
  port: 25, // Standard SMTP port
  secure: false, // True for 465, false for other ports
  tls: {
    rejectUnauthorized: false
  },
  // No authentication needed
});

interface EmailOptions {
  to: string;
  subject: string;
  body: string;
}

export const sendEmail = async (options: EmailOptions) => {
  try {
    await transporter.sendMail({
      from: '"ComeInUp" <no-reply@comeinup.com>',
      to: options.to,
      subject: options.subject,
      text: options.body,
    });
  } catch (error) {
    console.error('Email sending error:', error);
    throw new Error('Failed to send email');
  }
};