import { log } from "console";
import multer from "multer";

// middleware/upload.ts
export const upload = multer({
  storage: multer.memoryStorage(),
  fileFilter: (req, file, cb) => {
    console.log("This is file from config", file);
    if(file.mimetype.startsWith('image/')) cb(null, true);
    else cb(new Error('Only image files are allowed!'));
  },
  limits: { fileSize: 25 * 1024 * 1024 } // 25MB
});
// const storage = multer.memoryStorage()
// export const upload = multer({ storage: storage })