import express from 'express';
import mongoose from 'mongoose';
import dotenv from 'dotenv';
import cors from 'cors'; // Re-enable cors
import cookieParser from 'cookie-parser';
import bodyParser from 'body-parser';

import authRoutes from './routes/authentication';
import userRoutes from './routes/userRoutes';
import productRoutes from './routes/productRoutes';
import notificationRoutes from './routes/notificationRoutes';
import salesZoneRoutes from './routes/salesZoneRoutes';
import zoneRoutes from './routes/zoneRoutes';
import fileRoutes from './routes/fileRoutes';
import statusRoutes from './routes/statusRoutes';
import logRoutes from './routes/logRoutes';
import imageRoutes from './routes/imageRoutes';
import multer from 'multer';

dotenv.config();

const app = express();
const port = process.env.PORT || '3002';

// CORS configuration
app.use(cors());

const allowedOrigins = ['http://localhost:3000', 'https://backendalaahd.onrender.com'];

// Configure CORS
app.use(cors({
    origin: allowedOrigins,
    methods: ['GET', 'POST', 'PUT', 'DELETE'],
    credentials: true, // Allow cookies to be sent with requests
    allowedHeaders: ['Content-Type', 'Authorization', 'Cookie']
}));

// Middleware setup
app.use(express.json({ limit: '50mb' }));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: true }));
app.use(cookieParser());

// Routes
app.use('/api', authRoutes);
app.use('/api', userRoutes);
app.use('/api', productRoutes);
app.use('/api', notificationRoutes);
app.use('/api', salesZoneRoutes);
app.use('/api', zoneRoutes);
app.use('/api', fileRoutes);
app.use('/api', statusRoutes);
app.use('/api', logRoutes);
app.use('/api', imageRoutes);

const MDB =
  process.env.MONGO_URI ||
  'mongodb+srv://anas:anas@cluster0.nnfdp.mongodb.net/ComeInUp?retryWrites=true&w=majority&appName=Cluster0';

// MongoDB connection
mongoose
  .connect(MDB)
  .then(() => console.log('Connected to MongoDB'))
  .catch((err) => {
    console.error('MongoDB connection error:', err);
    process.exit(1); // Exit the process on connection failure
  });

// Start server
app.listen(port, () => console.log(`Server running on port ${port}`));
